using System;
using System.Collections;
using System.Collections.Generic;
using Server;
using Server.Mobiles;
using Server.Gumps;
using Server.Network;
using Server.Factions;

namespace Server.Guilds
{
	public class GuildBankGump : BaseGuildGump
	{
      public GuildBankGump( PlayerMobile pm, Guild g, int page ) : base( pm, g )
		{
			viewpage = page;
         PopulateGump();
		}
		
		private ArrayList Rewards;
		
		private int y_inc = 35;
		private int x_creditoffset = 350;
		private int x_pointsoffset = 480;
		private int maxItemsPerPage = 8;
		private int viewpage;

		public override void PopulateGump()
		{
			base.PopulateGump();			
		
			string html = "<basefont color=blue><center>GUILDOVNI BANKA    <basefont color=black>";
			html += String.Format( " Pocet kreditu: {0}", guild.Bank.ToString( "N0", Auberon.Chat.General.Nfi ) );
			AddHtml( 65, 83, 485, 30, html, false, false );
			
         Rewards = GuildCoinsRewards.RewardsList;
            
         int height = maxItemsPerPage * y_inc + 120;
         int width = x_pointsoffset + 110;
         
			if(Rewards != null && Rewards.Count > 0)
			{
            AddLabel( width - 145, height - 10, 0, String.Format("Page: {0}/{1}", viewpage+1, (int)(Rewards.Count/maxItemsPerPage)+1));

            // page up and down buttons
            AddButton( width - 55, height - 8, 0x15E0, 0x15E4, 13, GumpButtonType.Reply, 0 );
            AddButton( width - 35, height - 8, 0x15E2, 0x15E6, 12, GumpButtonType.Reply, 0 );
         }
         
			// display the items with their selection buttons
			if(Rewards != null)
			{
            int y = 85;
            
    			for(int i = 0; i < Rewards.Count; i++)
    			{
    			    if((int)(i/maxItemsPerPage) != viewpage) continue;

    			    GuildCoinsRewards r = Rewards[i] as GuildCoinsRewards;
    			    
               if(r == null) continue;

               y += y_inc;
               
               // display the item
        			if( r.Cost <= guild.Bank )
        			{
                  // add the selection button
        			    AddButton( 30, y, 0xFA5, 0xFA7, 1000 + i, GumpButtonType.Reply, 0 );
        			}

        			// display the name
        			AddLabel( 70, y + 3, 0, r.Name);
        			
        			// display the cost
        			AddLabel( x_pointsoffset + 20, y + 3, 0, r.Cost.ToString() );
    			}
			}			
		}

		public override void OnResponse( NetState state, RelayInfo info )
		{
			base.OnResponse( state, info );
			
         if(info == null || state == null || state.Mobile == null || Rewards == null) return;

			PlayerMobile from = state.Mobile as PlayerMobile;

			if( !IsMember( from, guild ) )
				return;

			switch ( info.ButtonID ) 
			{
                case 12:
                    // page up
                    int nitems = 0;
                    if(Rewards != null)
                        nitems = Rewards.Count;

                    int page = viewpage+1;
                    if(page > (int)(nitems/maxItemsPerPage))
                    {
                        page = (int)(nitems/maxItemsPerPage);
                    }
                    state.Mobile.SendGump( new GuildBankGump( from, guild, page ) );
                    break;
                case 13:
                    // page down
                    page = viewpage-1;
                    if(page < 0)
                    {
                        page = 0;
                    }
                    state.Mobile.SendGump( new GuildBankGump( from, guild, page ) );
                    break;
				default:
				{
                     if(info.ButtonID >= 1000)
                    {
                        int selection = info.ButtonID - 1000;
                        if(selection < Rewards.Count)
                        {
                            GuildCoinsRewards r = Rewards[selection] as GuildCoinsRewards;
                            
                            if ( from.GuildRank.Rank < r.Rank.Rank )
                            {
                              from.SendMessage( "Na nakup tohoto predmet je treba vyssi guild rank." );
                              from.SendGump(new GuildBankGump( from, guild, viewpage ));
                              return;
                            }
    
                            // check the price
                            if( r.Cost <= guild.Bank )
                            {
                                // create an instance of the reward type
                                object o = null;
                                
                                try
                                {
                                    o = Activator.CreateInstance( r.RewardType , r.RewardArgs );
                                }
                                catch {}

                                bool received = true;

                                if(o is Item)
                                {
                                    // and give them the item
                                    from.AddToBackpack((Item)o);
                                }
                                else if (o is Mobile)
                                {
                                    // if it is controllable then set the buyer as master.  Note this does not check for control slot limits.
                                    if(o is BaseCreature)
                                    {
                                        BaseCreature b = o as BaseCreature;
                                        b.Controlled = true;
                                        b.ControlMaster = from;
                                    }

                                    ((Mobile)o).MoveToWorld(from.Location, from.Map);

                                }
                                else if(o is Server.Engines.XmlSpawner2.XmlAttachment)
                                {
                                    Server.Engines.XmlSpawner2.XmlAttachment a = o as Server.Engines.XmlSpawner2.XmlAttachment;

                                    Server.Engines.XmlSpawner2.XmlAttach.AttachTo(from, a);
                                }
                                else
                                {
                                    from.SendMessage(33, "unable to create {0}.", r.RewardType.Name);
                                    received = false;
                                }
                                
                                // complete the transaction
                                if(received)
                                {
                                    // charge them
                                    guild.Bank -= r.Cost;
                                    from.SendMessage("Nakup probehl uspesne: {0} za {1} kreditu.", r.Name, r.Cost);
                                }
                            }
                            else
                            {
                                from.SendMessage("V guildovni bance neni dostatek kreditu pro nakup {0}.", r.Name);
                            }
                            
                            from.SendGump(new GuildBankGump( from, guild, viewpage ));
                        }
                    }
				    break;
				}
			}
		}
	}
}